@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
<section class="detail-show-all comn-padd-100">
  
    <div class="row row-gap-3">
      <div class="col-lg-6">
        <div class="cst_calender booking-main-page">
          <div id="calendar-box"></div>
        </div>
      </div>

      <div class="col-lg-6">
        <div class="row my_appiont_date_row mt-0">
          <div class="col-md-6">
            <h6 class="sub_heading_18">pickup date</h6>
            <div class="my_appiont_date_col">
              <div class="inner-main-input">
                <label class="form-label">Pick-up Date</label>
                <input class="form-control date-input" type="date" value="{{ \Carbon\Carbon::parse($cartItem->pickup_date)->format('Y-m-d') }}" readonly>
              </div>
              <p class="avail_slots_text">available slot</p>
              <ul id="from-slots" class="available_slots_row"></ul>
            </div>
          </div>

          <div class="col-md-6">
            <h6 class="sub_heading_18">drop-off date</h6>
            <div class="my_appiont_date_col">
              <div class="inner-main-input">
                <label class="form-label">Drop-off Date</label>
                <input class="form-control date-input" type="date" value="{{ \Carbon\Carbon::parse($cartItem->pickup_date)->addDays($cartItem->days - 1)->format('Y-m-d') }}" readonly>
              </div>
              <p class="avail_slots_text">available slot</p>
              <ul id="to-slots" class="available_slots_row"></ul>
            </div>
          </div>
        </div>
      </div>
    </div>
    <input id="pickup_date" value="{{ \Carbon\Carbon::parse($cartItem->pickup_date)->format('Y-m-d') }}" type="hidden">
    <input id="dropoff_date" value="{{ \Carbon\Carbon::parse($cartItem->pickup_date)->addDays($cartItem->days - 1)->format('Y-m-d') }}" type="hidden">
    <div id="custom-timing-inputs" style="display:none; margin-top:20px;">
        <div class="mb-3">
          <label for="customPickupTime" class="form-label">Enter your preferred Pick-up Time</label>
          <input type="text" id="customPickupTime" name="customPickupTime" class="form-control" placeholder="">
        </div>
        <div class="mb-3">
          <label for="customDropoffTime" class="form-label">Enter your preferred Drop-off Time</label>
          <input type="text" id="customDropoffTime" name="customDropoffTime" class="form-control" placeholder="">
        </div>

        <span>Please use this format 16:00 - 17:00</span>
    </div>

    <div class="text-end mt-4">
      <button id="confirmBookingBtn" class="btn primary-btn primary-btn2">Confirm Booking</button>
    </div>
 
</section>

</div>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>

<script>
 var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
 function checkSlotsAvailability() {
    const fromSlots = document.querySelectorAll('#from-slots .time-slot:not(.disabled)');
    const toSlots = document.querySelectorAll('#to-slots .time-slot:not(.disabled)');

    var pickup_date = $('#pickup_date').val();
    var dropoff_date = $('#dropoff_date').val();

    const allFromDisabled = fromSlots.length === 0;
    const allToDisabled = toSlots.length === 0;

    if (allFromDisabled || allToDisabled || (pickup_date == dropoff_date)) {
        document.getElementById('custom-timing-inputs').style.display = 'block';
        document.getElementById('from-slots').style.display = 'none';
        document.getElementById('to-slots').style.display = 'none';
    }
}
document.addEventListener("DOMContentLoaded", function () {
    const rentalFrom = "{{ $cartItem->pickup_date }}";
    const rentalTo = "{{ \Carbon\Carbon::parse($cartItem->pickup_date)->addDays($cartItem->days - 1)->format('Y-m-d') }}";
    const vendorId = "{{ $cartItem->vendor_id }}";

    flatpickr("#calendar-box", {
    inline: true,
    mode: "range",
    defaultDate: [rentalFrom, rentalTo],
    locale: {
        firstDayOfWeek: 1  // ✅ Monday as the first day
    },
    disable: [
        function(date) {
            const start = new Date(rentalFrom);
            const end = new Date(rentalTo);
            return !(date >= start && date <= end);
        }
    ]
});

    fetchTimeSlots(rentalFrom, '#from-slots').then(() => {
      fetchTimeSlots(rentalTo, '#to-slots').then(() => {
        checkSlotsAvailability();
      });
    });

    function fetchTimeSlots(date, container) {
        return fetch(`${baseUrl}/working-hours?date=${date}&container=${encodeURIComponent(container)}&vendor_id=${vendorId}`)
        .then(response => response.json())
        .then(data => {
            const slots = data.slots || generateSlots(data.from_time, data.to_time);
            document.querySelector(container).innerHTML = slots.map(slot => {
                const label = typeof slot === 'string' ? slot : slot.label;
                const isDisabled = typeof slot === 'object' && slot.disabled;
                return `<li class="time-slot ${isDisabled ? 'disabled' : ''}" data-slot="${label}">${label}</li>`;
            }).join('');
        });
    }


    function generateSlots(from, to) {
        const start = moment(from, "HH:mm");
        const end = moment(to, "HH:mm");
        const slots = [];

        while (start.clone().add(15, 'minutes').isSameOrBefore(end)) {
            const slotStart = start.clone();
            const slotEnd = slotStart.clone().add(15, 'minutes');
            slots.push(`${slotStart.format("HH:mm")} - ${slotEnd.format("HH:mm")}`);
            start.add(30, 'minutes');
        }

        return slots;
    }

    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('time-slot') && !e.target.classList.contains('disabled')) {
            e.target.parentElement.querySelectorAll('.time-slot').forEach(slot => {
                slot.classList.remove('active');
            });
            e.target.classList.add('active');
        }
    });

    document.getElementById('confirmBookingBtn').addEventListener('click', function () {
        let pickupTime, dropoffTime;
        const customPickup = document.getElementById('customPickupTime').value.trim();
        const customDropoff = document.getElementById('customDropoffTime').value.trim();

        if (document.getElementById('custom-timing-inputs').style.display === 'block') {
            if (!customPickup || !customDropoff) {
                return alert('Please enter both your preferred pickup and dropoff times.');
            }
            pickupTime = customPickup;
            dropoffTime = customDropoff;
        } else {
            const fromSlot = document.querySelector('#from-slots .time-slot.active');
            const toSlot = document.querySelector('#to-slots .time-slot.active');

            if (!fromSlot || !toSlot) {
                return window.location.href = `${baseUrl}/vendor/cart`;
            }

            pickupTime = fromSlot.dataset.slot;
            dropoffTime = toSlot.dataset.slot;
        }

        var pickup_date = $('#pickup_date').val();
        var dropoff_date = $('#dropoff_date').val();

        if(pickup_date == dropoff_date){
          if(pickupTime == dropoffTime){
            alert('Pickup and dropoff time cannot be same for the same date');
            return false;
          }
        }

        const payload = {
            cart_item_id: {{ $cartItem->id }},
            pickup_time: pickupTime,
            dropoff_time: dropoffTime,
            user_timing: document.getElementById('custom-timing-inputs').style.display === 'block' ? true : false,
            pickup_date : pickup_date,
            dropoff_date: dropoff_date
        };

        fetch(`${baseUrl}/vendor/cart/confirm-slot`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify(payload)
        }).then(response => {
            if (response.ok) {
                window.location.href = `${baseUrl}/vendor/cart`;
            } else {
                alert('Failed to confirm booking.');
            }
        });
    });
});
</script>


<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<style>
.time-slot {
    padding: 6px 10px;
    margin: 4px;
    border: 1px solid #ccc;
    cursor: pointer;
    display: inline-block;
    border-radius: 5px;
    background-color: #f7f7f7;
    font-size: 14px;
}

.time-slot.active {
    background-color: #007bff;
    color: white;
    border-color: #007bff;
}

.time-slot.disabled {
    background-color: #e0e0e0;
    color: #999;
    cursor: not-allowed;
    pointer-events: none;
}
</style>
@endsection